<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Parent extends Model 
{

    protected $table = 'parents';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'mobile', 'email', 'national_id', 'address', 'job', 'gender', 'date_birth', 'password');
    protected $hidden = array('password');

    public function students()
    {
        return $this->hasMany('App\Models\Student');
    }

}